<?php
get_header(); ?>
    <div class="wrap">
        <div id="primary" class="content-area">
            <main id="main" class="site-main">
                <?php if (get_theme_mod('osf_page_404_page_enable') != 'default' && !empty(get_theme_mod('osf_page_404_page_custom'))): ?>
                    <?php $query = new WP_Query('page_id=' . get_theme_mod('osf_page_404_page_custom'));
                    if ($query->have_posts()):
                        while ($query->have_posts()) : $query->the_post();
                            the_content();
                        endwhile;
                    endif; ?>
                <?php else: ?>
                    <section class="error-404 not-found">
                        <div class="page-content">
                            <div class="row d-flex align-items-center text-lg-left text-center">
                                <div class="col-xl-6 col-lg-5">
                                    <img class="my-5"
                                         src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/404-image.jpg') ?>" alt="<?php echo esc_attr('404 page')?>"/>
                                </div>
                                <div class="col-xl-6 col-lg-7">
                                    <img class="mb-2"
                                         src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/404.png') ?>" alt="<?php echo esc_attr('404')?>"/>
                                    <div class="error-title">
                                        <?php esc_html_e('Oops, that link is broken.', 'worldlife'); ?>
                                    </div>
                                    <div class="error-text">
                                        <p><?php esc_html_e('Page doesn’t exist or some other error occurred. Go to our homepage', 'worldlife'); ?></p>
                                        <a href="<?php echo esc_url(home_url('/')); ?>"
                                           class="button-primary "><?php esc_html_e('Go to Homepage', 'worldlife'); ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section><!-- .error-404 -->
                <?php endif; ?>
            </main><!-- #main -->
        </div><!-- #primary -->
    </div><!-- .wrap -->

<?php get_footer();
