<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class OSF_Give {
    private $template;

    public function __construct() {
        $this->template = trailingslashit(WORLDLIFE_CORE_PLUGIN_DIR) . 'templates/give';
        $this->hooks_single();

        // Wrapper
        add_filter('give_default_wrapper_start', [$this, 'template_wrapper_start']);

        // Donation Confirm
        add_action('give_email_access_form_login', [$this, 'email_access_form_login']);

        add_action('wp_ajax_get_worldlife_gallery', array($this, 'ajax_gallery'));
        add_action('wp_ajax_nopriv_get_worldlife_gallery', array($this, 'ajax_gallery'));

        add_action('wp_ajax_get_worldlife_video', array($this, 'ajax_video'));
        add_action('wp_ajax_nopriv_get_worldlife_video', array($this, 'ajax_video'));

        add_action('wp_enqueue_scripts', array($this, 'add_scripts'), 100);
    }


    private function hooks_single() {
        add_action('give_single_form_summary', [$this, 'single_start_form_summary'], 1);
        add_action('give_single_form_summary', [$this, 'show_form_images'], 3);
        add_action('give_single_form_summary', [$this, 'single_label'], 4);
        add_action('give_single_form_summary', [$this, 'single_end_form_summary'], 6);
        add_action('give_single_form_summary', [$this, 'single_end_form_summary_1'], 100);
        add_action('give_single_form_summary', [$this, 'tab_after_summary'], 200);
        add_filter('single_give_form_large_thumbnail_size', [$this, 'update_featured_image_size']);

        add_action('cmb2_admin_init', array($this, 'page_meta_box'));

        remove_action('give_pre_form_output', 'give_form_content', 10);
//        add_action('give_pre_form_output', [$this, 'give_form_the_except'], 40);

        //remove default Color Process Goal
        add_filter('give_forms_donation_goal_metabox_fields', [$this, 'remove_default_progress_goal_color']);
    }

    public function add_scripts() {
        $dev_mode = get_theme_mod('osf_dev_mode', false);
        wp_enqueue_script('otf-give-script', trailingslashit(WORLDLIFE_CORE_PLUGIN_URL) . 'assets/js/give/main.js', array('jquery'), false, true);
        wp_localize_script('otf-give-script', 'worldlife', array(
            'ajaxurl' => admin_url('admin-ajax.php'),
        ));

        if (class_exists('Give') && !$dev_mode) {
            wp_enqueue_style('osf-give-core', trailingslashit(WORLDLIFE_CORE_PLUGIN_URL) . 'assets/css/give/style.css', array(
                'worldlife-style'
            ), WORLDLIFE_CORE_VERSION);
        }
    }

    public function remove_default_progress_goal_color($args) {
        foreach ($args as $key => $val) {
            if (isset($val['id']) && $val['id'] === '_give_goal_color') {
                unset($args[$key]['default']);
            }
        }
        return $args;
    }

    public function give_form_the_except() {
        echo '<div class="give-execpt">';
        the_excerpt();
        echo '</div>';
    }


    public function tab_after_summary() {
        wp_enqueue_script("jquery-ui-tabs");
        $gallery      = osf_get_metabox(get_the_ID(), 'osf_give_gallery');
        $video        = osf_get_metabox(get_the_ID(), 'osf_give_video');
        $show_content = give_get_form_content_placement(get_the_ID(), []);

        ?>
        <div id="give-form-single-tab" class="give-form-tabs">
            <ul>
                <?php if ($show_content): ?>
                    <li><a href="#tabs-1"><?php echo esc_html__('description', 'worldlife-core'); ?></a></li>
                <?php endif; ?>
                <li><a href="#tabs-2"><?php echo esc_html__('donors', 'worldlife-core'); ?>
                        <sup><?php echo give_get_form_donor_count(get_the_ID()); ?></sup></a></li>
                <?php if ($video) {
                    echo '<li><a href="#tabs-3">' . esc_html__('video', 'worldlife-core') . '</a></li>';
                } ?>
                <?php if ($gallery) {
                    echo '<li><a href="#tabs-4">' . esc_html__('gallery', 'worldlife-core') . '</a></li>';
                } ?>
            </ul>
            <?php if ($show_content): ?>
                <div id="tabs-1">
                    <?php give_form_display_content(get_the_ID(), []); ?>
                </div>
            <?php endif; ?>

            <div id="tabs-2">
                <?php echo do_shortcode('[give_donor_wall form_id="' . get_the_ID() . '"]') ?>
            </div>
            <?php if ($video) {
                $url = esc_url(get_post_meta(get_the_ID(), 'osf_give_video', 1));
                echo '<div id="tabs-3">' . wp_oembed_get($url) . '</div>';
            }
            ?>
            <?php if ($gallery) {
                echo '<div id="tabs-4">' . do_shortcode('[gallery link="file" columns="3"  size="worldlife-featured-image-small" ids="' . implode(", ", array_keys($gallery)) . '"]') . '</div>';
            }
            ?>
        </div>
        <?php
    }

    public function email_access_form_login() {
        ?>
        <div class="opal-give-message give-form">
            <div class="img-give-form">
                <i class="fa fa-envelope-o" aria-hidden="true"></i>
            </div>
            <p>
                <?php
                echo esc_html(apply_filters('give_email_access_welcome_message', __('Please verify your email to access your donation history.', 'worldlife-core')));
                ?>
            </p>
        </div>
        <?php
    }

    public function template_wrapper_start() {
        return '<div id="give-wrap" class="give-wrap"><div class="give-wrap-inner">';
    }

    public function single_label() {
        $form                = new Give_Donate_Form(get_the_ID());
        $goal_progress_stats = give_goal_progress_stats($form);
        $income              = $goal_progress_stats['raw_actual'];
        $goal                = $goal_progress_stats['raw_goal'];
        echo '<div class="opal-give-group-title">';
        if ($income >= $goal) {
            echo '<div class="label success">' . esc_html__('Successful', 'worldlife-core') . '</div>';
        } else {
            echo '<div class="label unsuccess">' . esc_html__('Unsuccessful', 'worldlife-core') . '</div>';
        }
    }

    public function single_start_form_summary() {
        echo '<div class="summary-inner"><div class="opal-give-single-media">';
    }

    public function single_end_form_summary() {
        echo '</div></div>';
    }

    public function single_end_form_summary_1() {
        echo '</div>';
    }

    public function update_featured_image_size() {
        return 'worldlife-give-single';
    }

    public function show_form_images() {
        give_get_template_part('single-give-form/featured-image');
    }

    public function page_meta_box() {

        $cmb2 = new_cmb2_box(array(
            'id'            => 'osf_give',
            'title'         => __('Donation Media', 'worldlife-core'),
            'object_types'  => array('give_forms'),
            'context'       => 'normal',
            'priority'      => 'high',
            'show_names'    => false,
            'vertical_tabs' => true,
            'tabs'          => array(
                array(
                    'id'     => 'osf_give_tab1',
                    'title'  => __('Video', 'worldlife-core'),
                    'fields' => array(
                        'osf_give_video'
                    ),
                ),
                array(
                    'id'     => 'osf_give_tab2',
                    'title'  => __('Gallery', 'worldlife-core'),
                    'fields' => array(
                        'osf_give_gallery'
                    ),
                ),
            )
        ));

        $cmb2->add_field(array(
            'name' => __('Donation video', 'worldlife-core'),
            'desc' => __('Supports video from youtube and vimeo.', 'worldlife-core'),
            'id'   => 'osf_give_video',
            'type' => 'oembed',
        ));

        $cmb2->add_field(array(
            'name' => 'Donation gallery',
            'desc' => '',
            'id'   => 'osf_give_gallery',
            'type' => 'file_list',
        ));
    }

    public function ajax_video() {
        $give_id = $_POST['give_id'];
        $video   = osf_get_metabox($give_id, 'osf_give_video');
        wp_send_json($video);
    }

    public function ajax_gallery() {
        $give_id = $_POST['give_id'];
        $gallery = osf_get_metabox($give_id, 'osf_give_gallery');;
        wp_send_json($gallery);
    }
}

return new OSF_Give();
