<?php

//namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Control_Media;

class OSF_Elementor_Timeline extends OSF_Elementor_Carousel_Base
{

    public function get_name()
    {
        return 'opal-timeline';
    }

    public function get_title()
    {
        return __('Opal Timeline', 'worldlife-core');
    }

    public function get_categories()
    {
        return array('opal-addons');
    }

    public function get_icon()
    {
        return 'eicon-time-line';
    }


//    public function get_script_depends()
//    {
//        return [
//            'timeline',
//            'parallaxmouse',
//            'tweenmax',
//            'tilt',
//            'waypoints',
//        ];
//    }

    public static function get_button_sizes()
    {
        return [
            'xs' => __('Extra Small', 'worldlife-core'),
            'sm' => __('Small', 'worldlife-core'),
            'md' => __('Medium', 'worldlife-core'),
            'lg' => __('Large', 'worldlife-core'),
            'xl' => __('Extra Large', 'worldlife-core'),
        ];
    }


    protected function _register_controls()
    {

        $this->start_controls_section(
            'section_general',
            [
                'label' => __('General', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'column',
            [
                'label' => __('Columns', 'worldlife-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 3,
                'options' => [1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6],
            ]
        );

        $repeater = new \Elementor\Repeater();

//        $repeater->add_control(
//            'image_title',
//            [
//                'label' => __('Image', 'strollik5-core'),
//                'type' => Controls_Manager::TEXT,
//                'default' => __('Timeline Title', 'strollik5-core'),
//                'label_block' => true,
//            ]
//        );c
        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'worldlife-core'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => __('Title & Content', 'worldlife-core'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Timeline Title', 'worldlife-core'),
                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'content',

            [
                'label' => __('Content', 'worldlife-core'),
                'type' => Controls_Manager::WYSIWYG,
                'default' => __('Timeline Content', 'worldlife-core'),
                'show_label' => false,
            ]
        );
        $repeater->add_control(
            'content_animation',
            [
                'label' => __('Content Animation', 'worldlife-core'),
                'type' => Controls_Manager::ANIMATION,
                'frontend_available' => true,
            ]
        );
        $repeater->add_control(
            'content_animation_duration',
            [
                'label' => __('Animation Duration', 'worldlife-core'),
                'type' => Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'slow' => __('Slow', 'worldlife-core'),
                    '' => __('Normal', 'worldlife-core'),
                    'fast' => __('Fast', 'worldlife-core'),
                ],
                'condition' => [
                    'content_animation!' => '',
                ],
            ]
        );
        $repeater->add_control(
            'content_animation_delay',
            [
                'label' => __('Animation Delay', 'worldlife-core') . ' (ms)',
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'min' => 0,
                'step' => 100,
                'condition' => [
                    'content_animation!' => '',
                ],
                'render_type' => 'none',
                'frontend_available' => true,
            ]
        );

        $repeater->add_control(
            'buttom',
            [
                'label' => __('Buttom', 'worldlife-core'),
                'type' => Controls_Manager::TEXT,
                'separator' => 'before',
                'placeholder' => __('Buttom name', 'worldlife-core'),

                'label_block' => true,
            ]
        );
        $repeater->add_control(
            'link',
            [
                'label' => __('Link', 'worldlife-core'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('https://your-link.com', 'worldlife-core'),
                'default' => [
                    'url' => '#',
                ],
            ]
        );
        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(), [
                'name' => 'thumbnail',
                // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `testimonial_image_size` and `testimonial_image_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );
        $repeater->add_control(
            'activate',
            [
                'label' => __('Activate', 'worldlife-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_off' => __('Off', 'worldlife-core'),
                'label_on' => __('On', 'worldlife-core'),
            ]
        );


        $this->add_control(
            'timeline_list',
            [
                'label' => __('Timeline Items', 'worldlife-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'title' => __('Timeline #1', 'worldlife-core'),
                        'content' => __('If you remember the very first time you have met with the person you love or your friend, it would be nice to let the person know that you still remember that very moment.', 'worldlife-core'),
                        'image' => Utils::get_placeholder_image_src(),
                        'bottom' => '',
                        'link' => '#'
                    ],
                    [
                        'title' => __('Timeline #2', 'worldlife-core'),
                        'content' => __('If you remember the very first time you have met with the person you love or your friend, it would be nice to let the person know that you still remember that very moment.', 'worldlife-core'),
                        'image' => Utils::get_placeholder_image_src(),
                        'bottom' => '',
                        'link' => '#'
                    ],
                    [
                        'title' => __('Timeline #3', 'worldlife-core'),
                        'content' => __('If you remember the very first time you have met with the person you love or your friend, it would be nice to let the person know that you still remember that very moment.', 'worldlife-core'),
                        'image' => Utils::get_placeholder_image_src(),
                        'bottom' => '',
                        'link' => '#'
                    ],
                ],
                'title_field' => '{{{ title }}}',

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_item_style',
            [
                'label' => __('Item', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]

        );

        $this->add_control(
            'content_align',
            [
                'label' => __('Alignment', 'worldlife-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'worldlife-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'worldlife-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'worldlife-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .timeline-item  ' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control('padding',
            [
                'label' => esc_html__('Padding', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-item  ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .timeline-item',
            ]
        );
        $this->add_responsive_control(
            'item_spacing_item',
            [
                'label' => __('Spacing', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Image
        $this->start_controls_section(
            'style_image',
            [
                'label' => __('Image', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(), [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .timeline-item-image img',
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-item-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(), [
                'name' => 'item_box_shadow',
                'selector' => '{{WRAPPER}} .timeline-item-image img',
            ]
        );

        $this->add_responsive_control(
            'image_spacing',
            [
                'label' => __('Spacing', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-item-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'number_style',
            [
                'label' => __('Number', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('number_colors_tab');

        $this->start_controls_tab(
            'number_color_normal',
            [
                'label' => __('Normal', 'worldlife-core'),
            ]
        );
        $this->add_control(
            'number_color',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .timeline-number' => 'color: {{VALUE}};',
                ],

            ]
        );
        $this->add_control(
            'number_background_color',
            [
                'label' => __('Background Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-number' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .timeline-number:before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'number_color_activate',
            [
                'label' => __('Activate', 'worldlife-core'),
            ]
        );
        $this->add_control(
            'number_color_2',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .timeline-item-activate .timeline-number' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .timeline-carosuel-item:hover .timeline-number' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'number_background_color_2',
            [
                'label' => __('Background Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-item-activate .timeline-number' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .timeline-item-activate .timeline-number:before' => 'background-color: {{VALUE}};',
                    '{{WRAPPER}} .timeline-carosuel-item:hover .timeline-number' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'number_border_color',
            [
                'label' => __('Border Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-item-activate .timeline-number' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .timeline-carosuel-item:hover .timeline-number' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border_number',
                'placeholder' => '1px',
                'default' => '1px',
                'selector' => '{{WRAPPER}} .timeline-number',
            ]
        );

        $this->add_control(
            'number_border_radius',
            [
                'label' => __('Border Radius', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
//        $this->add_responsive_control(
//            'side_number',
//            [
//                'label' => __('Size', 'strollik5-core'),
//                'type' => Controls_Manager::SLIDER,
//                'range' => [
//                    'px' => [
//                        'min' => 50,
//                        'max' => 200,
//                    ],
//                ],
//                'size_units' => ['px', 'em', '%'],
//                'selectors' => [
//                    '{{WRAPPER}} .timeline-number' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
//                ],
//            ]
//        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'number_typography',
                'selector' => '{{WRAPPER}} .timeline-number',
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
            ]
        );

        $this->add_responsive_control(
            'number_spacing_item',
            [
                'label' => __('Spacing', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-number' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style',
            [
                'label' => __('Title', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Title', 'worldlife-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .timeline-title' => 'color: {{VALUE}};',
                ],
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_2,
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .timeline-title',
                'scheme' => Scheme_Typography::TYPOGRAPHY_1,
            ]
        );
        $this->add_responsive_control(
            'title_spacing_item',
            [
                'label' => __('Spacing', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => __('Content', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .content' => 'color: {{VALUE}};',
                ],
                'scheme' => [
                    'type' => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_3,
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} .content',
                'scheme' => Scheme_Typography::TYPOGRAPHY_3,
            ]
        );
        $this->add_responsive_control(
            'content_spacing_item',
            [
                'label' => __('Spacing', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .content' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'buttom_style',
            [
                'label' => __('Butttom', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'button_type',
            [
                'label' => __('Type', 'worldlife-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'primary',
                'options' => [
                    '' => __('Default', 'worldlife-core'),
                    'primary' => __('Primary', 'worldlife-core'),
                    'secondary' => __('Secondary', 'worldlife-core'),
                    'outline_primary' => __('Outline Primary', 'worldlife-core'),
                    'outline_secondary' => __('Outline Secondary', 'worldlife-core'),
                    'link' => __('Link', 'worldlife-core'),
                    'info' => __('Info', 'worldlife-core'),
                    'success' => __('Success', 'worldlife-core'),
                    'warning' => __('Warning', 'worldlife-core'),
                    'danger' => __('Danger', 'worldlife-core'),
                ],
                'prefix_class' => 'elementor-button-',
            ]
        );
        $this->add_control(
            'buttom_size',
            [
                'label' => __('Size', 'worldlife-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'md',
                'options' => self::get_button_sizes(),
                'style_transfer' => true,
            ]
        );


        $this->end_controls_section();

        // Carousel Option
        $this->add_control_carousel();

    }

    public function set_render_attribute($element, $key = null, $value = null)
    {
        return $this->add_render_attribute($element, $key, $value, true);
    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper', 'class', 'elementor-timeline');
        if ($settings['enable_carousel'] === 'yes') {
            $this->add_render_attribute('row', 'class', 'owl-carousel owl-theme');
            $carousel_settings = $this->get_carousel_settings();
            $this->add_render_attribute('row', 'data-settings', wp_json_encode($carousel_settings));
        } else {
            $this->add_render_attribute('row', 'class', 'row');
            $this->add_render_attribute('row', 'data-elementor-columns', $settings['column']);
            if (!empty($settings['column_tablet'])) {
                $this->add_render_attribute('row', 'data-elementor-columns-tablet', $settings['column_tablet']);
            }
            if (!empty($settings['column_mobile'])) {
                $this->add_render_attribute('row', 'data-elementor-columns-mobile', $settings['column_mobile']
                );
            }
            $this->add_render_attribute('item', 'class', 'column-item');
        }

        ?>

        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <div <?php echo $this->get_render_attribute_string('row') ?>>
                <?php
                foreach ($settings['timeline_list'] as $index => $item) :

                    //content
                    $content_animation_dur = '';
                    $content = 'content_' . $index;

                    if ('' != $item['content_animation_duration']) {
                        $content_animation_dur = 'animated-' . $item['content_animation_duration'];

                    }
                    $content_animation_class = $item['content_animation'] ? $item['content_animation'] : '';

                    if (!empty($item['content_animation_delay'])) {
                        $this->add_render_attribute($content, 'data-timeline-animation-delay', $item['content_animation_delay']);
                    }
                    $this->add_render_attribute($content, 'class', 'timeline-content');
                    $this->add_render_attribute($content, 'class', 'timeline-animation');
                    $this->add_render_attribute($content, 'data-timeline-animation',
                        [
                            $content_animation_class,
                            $content_animation_dur,
                        ]
                    );

                    //button
                    $link_key = 'link_' . $index;
                    $number = $index + 1;
                    $this->add_render_attribute($link_key, 'class', 'elementor-button');
                    $this->add_render_attribute($link_key, 'class', 'elementor-size-' . $settings['buttom_size']);
                    $class_item = $index;
                    if ($item['activate']) {
                        $class_item .= ' timeline-item-activate';
                    }

                    if (!empty($item['link']['url'])) {
                        $this->add_render_attribute($link_key, 'href', $item['link']['url']);
                        if ($item['link']['is_external']) {
                            $this->add_render_attribute($link_key, 'target', '_blank');
                        }

                        if ($item['link']['nofollow']) {
                            $this->add_render_attribute($link_key, 'rel', 'nofollow');
                        }
                    }

                    ?>
                    <div <?php echo $this->get_render_attribute_string('item') ?>>
                        <div class="timeline-item timeline-item-<?php echo esc_attr($class_item) ?>">
                            <div class="timeline-image-wrap">
                                <?php $this->render_image($settings, $item); ?>
                                <div class="timeline-number-wrap">
                                    <div class="timeline-number">
                                        <span><?php echo $number; ?></span>
                                    </div>
                                </div>

                            </div>

                            <div <?php echo $this->get_render_attribute_string($content); ?>>

                                <?php if (!empty($item['title'])) : ?>
                                    <h2 class="timeline-title"><?php echo $item['title']; ?></h2>
                                <?php endif; ?>

                                <?php if (!empty($item['content'])) : ?>
                                    <div class="content">
                                        <?php echo $this->parse_text_editor($item['content']); ?>
                                    </div>
                                <?php endif; ?>

                                <?php if (!empty($item['buttom'])) : ?>
                                    <div class="timeline-buttom">
                                        <a <?php echo $this->get_render_attribute_string($link_key); ?>>
                                            <?php echo $item['buttom']; ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php
    }

    private function render_image($settings, $item)

    {
        ?>
        <div class="timeline-item-image">
            <?php
            $item['image_size'] = $settings['thumbnail_size'];
            $item['image_custom_dimension'] = $settings['thumbnail_custom_dimension'];
            if (!empty($item['image']['url'])) :
                $image_html = Group_Control_Image_Size::get_attachment_image_html($item, 'image');
                echo $image_html;
            endif;
            ?>
        </div>
        <?php
    }
}

$widgets_manager->register_widget_type(new OSF_Elementor_Timeline());