<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!class_exists('Give')) {
    return;
}

use Elementor\Controls_Manager;

class OSF_Elementor_Give_Campain extends OSF_Elementor_Carousel_Base
{

    public function get_name()
    {
        return 'opal-give-campain';
    }

    public function get_title()
    {
        return __('Opal Give Form Grid', 'worldlife-core');
    }

    public function get_categories()
    {
        return array('opal-addons');
    }

    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_give_form',
            [
                'label' => __('Give Form Grid', 'worldlife-core'),
            ]
        );

        $this->add_control(
            'form_id',
            [
                'label' => __('Form ids', 'worldlife-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => $this->get_form_ids(),
                'multiple' => true,
                'description' => __('Enter a comma-separated list of form IDs. If empty, all published forms are displayed.', 'worldlife-core'),
            ]
        );

        $this->add_control(
            'excluded_form_id',
            [
                'label' => __('Excluded Form IDs', 'worldlife-core'),
                'type' => Controls_Manager::SELECT2,
                'options' => $this->get_form_ids(),
                'multiple' => true,
                'description' => __('Enter a comma-separated list of form IDs to exclude those from the grid.', 'worldlife-core'),
            ]
        );
        $enable_category = give_is_setting_enabled(give_get_option('categories', 'disabled'));
        if ($enable_category) {
            $this->add_control(
                'cats',
                [
                    'label' => __('Category IDs', 'worldlife-core'),
                    'type' => Controls_Manager::SELECT2,
                    'options' => $this->get_form_taxonomy(),
                    'multiple' => true,
                ]
            );
        }

        $this->add_responsive_control(
            'column',
            [
                'label' => __('Columns', 'worldlife-core'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 4,
                'options' => [1 => 1, 2 => 2, 3 => 3, 4 => 4, 5 => 5, 6 => 6],
                'description' => __('Sets the number of forms per row.', 'worldlife-core'),
            ]
        );
        $this->add_control(
            'show_goal',
            [
                'label' => __('Show Goal', 'worldlife-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => 'Hide',
                'label_off' => 'Show',
                'default' => 'yes',
                'description' => __('Do you want to display the goal\'s progress bar?', 'worldlife-core'),
            ]
        );
        $this->add_control(
            'show_excerpt',
            [
                'label' => __('Show Excerpt', 'worldlife-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => 'Hide',
                'label_off' => 'Show',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'show_featured_image',
            [
                'label' => __('Show Featured Image', 'worldlife-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => 'Hide',
                'label_off' => 'Show',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'display_style',
            [
                'label' => __('display_style', 'worldlife-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'redirect' => __('Redirect', 'worldlife-core'),
                    'modal_reveal' => __('Modal', 'worldlife-core'),
                ],
                'default' => 'redirect'
            ]
        );

        $this->add_control(
            'forms_per_page',
            [
                'label' => __('Forms Per Page', 'worldlife-core'),
                'type' => Controls_Manager::NUMBER,
                'default' => 12,
            ]
        );

        $this->add_control(
            'show_paged',
            [
                'label' => __('Enables/Disables pagination', 'worldlife-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => 'Hide',
                'label_off' => 'Show',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_length',
            [
                'label' => __('Excerpt Length', 'worldlife-core'),
                'type' => Controls_Manager::NUMBER,
                'default' => 25,
            ]
        );
        $this->add_control(
            'style',
            [
                'label' => __('Style', 'worldlife-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => __('Style 1', 'worldlife-core'),
                    'style-2' => __('Style 2', 'worldlife-core'),
                    'style-3' => __('Style 3', 'worldlife-core'),
                ],
                'default' => 'style-1',
                'prefix_class' => 'campain-grid-'
            ]
        );

        $this->end_controls_section();
        $this->add_control_carousel();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $atts = [
            'columns' => $settings['column'],
            'show_goal' => $settings['show_goal'],
            'show_excerpt' => $settings['show_excerpt'],
            'show_featured_image' => $settings['show_featured_image'],
            'display_style' => $settings['display_style'],
            'forms_per_page' => $settings['forms_per_page'],
            'paged' => $settings['show_paged'],
            'excerpt_length' => $settings['excerpt_length'],
            'image_size' => 'worldlife-featured-image-large'
        ];
        if ($settings['columns'] <= 2) {
            $atts['image_size'] = 'full';
        }
        if (!empty($settings['form_id'])) {
            $atts['ids'] = implode(',', $settings['form_id']);
        }
        if (!empty($settings['excluded_form_id'])) {
            $atts['exclude'] = implode(',', $settings['excluded_form_id']);
        }
        if (!empty($settings['cats'])) {
            $atts['cats'] = implode(',', $settings['cats']);
        }
        $code = '';

        foreach ($atts as $key => $value) {
            $code .= $key . '="' . (empty($value) ? 'false' : $value) . '" ';
        }

        if ($settings['enable_carousel'] === 'yes') {
            $this->add_render_attribute('wrap', 'class', 'carousel-activate');

            $carousel_settings = $this->get_carousel_settings();
            $this->add_render_attribute('wrap', 'data-settings', wp_json_encode($carousel_settings));
        }else {
            $this->add_render_attribute('wrap', 'class', 'carousel-111');
        }

        echo '<div ' . $this->get_render_attribute_string('wrap') . '>';
        echo do_shortcode('[give_form_grid ' . $code . ' ]');
        echo '</div>';

    }

    private function get_form_ids()
    {
        $args = array(
            'post_type' => 'give_forms',
            'posts_per_page' => -1,
            'post_status' => 'publish',
        );
        $give_form_ids = array();
        $give_forms = get_posts($args);
        foreach ($give_forms as $give_form) {
            $form_title = empty($give_form->post_title) ? sprintf(__('Untitled (#%s)', 'worldlife-core'), $give_form->ID) : $give_form->post_title;
            $give_form_ids[$give_form->ID] = $form_title;
        }
        return $give_form_ids;
    }

    private function get_form_taxonomy()
    {
        $enable_category = give_is_setting_enabled(give_get_option('categories', 'disabled'));
        if ($enable_category) {
            $args = array(
                'hide_empty' => false,
                'orderby' => 'name',
                'order' => 'ASC',
                'number' => 0,
            );
            $terms = get_terms('give_forms_category', $args);
            $give_form_taxonomy = array();
            foreach ($terms as $term) {
                $give_form_taxonomy[$term->term_id] = $term->name;
            }
            return $give_form_taxonomy;
        }
    }
}

$widgets_manager->register_widget_type(new OSF_Elementor_Give_Campain());