<?php
// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

function stories_shortcode($atts) {
    $atts = shortcode_atts(array(
        'posts_per_page' => 12,
    ), $atts);
    $atts['posts_per_page'] = intval($atts['posts_per_page']);
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $query_args = [
        'post_type'           => 'osf_stories',
        'ignore_sticky_posts' => 1,
        'post_status'         => 'publish',
        'posts_per_page'      => $atts['posts_per_page'],
        'paged'               => $paged
    ];

    $query = new WP_Query($query_args);
    global $post;
    $count = 0;
    while ($query->have_posts()) {
        $query->the_post();
        $post->loop = $count++;
        $post->post_count = $query->post_count;
        get_template_part('template-parts/story/content', 'stories');
    }
    wp_reset_postdata();
    $paginate_args = array(
        'current'   => max(1, get_query_var('paged')),
        'total'     => $query->max_num_pages,
        'show_all'  => false,
        'end_size'  => 1,
        'mid_size'  => 2,
        'prev_next' => true,
        'type'      => 'plain',
        'add_args'  => false,
    );

    printf('<nav class="navigation" role="navigation">%s</nav>',
        paginate_links($paginate_args)
    );
}

add_shortcode('opal_stories', 'stories_shortcode');

function event_shortcode($atts) {
    $atts = shortcode_atts(array(
        'posts_per_page' => 12,
    ), $atts);
    $atts['posts_per_page'] = intval($atts['posts_per_page']);
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $query_args = [
        'post_type'           => 'osf_event',
        'ignore_sticky_posts' => 1,
        'post_status'         => 'publish',
        'posts_per_page'      => $atts['posts_per_page'],
        'paged'               => $paged
    ];

    $query = new WP_Query($query_args);
    global $post;
    $count = 0;
    while ($query->have_posts()) {
        $query->the_post();
        $post->loop = $count++;
        $post->post_count = $query->post_count;
        get_template_part('template-parts/event/content', 'event');
    }
    wp_reset_postdata();
    $paginate_args = array(
        'current'   => max(1, get_query_var('paged')),
        'total'     => $query->max_num_pages,
        'show_all'  => false,
        'end_size'  => 1,
        'mid_size'  => 2,
        'prev_next' => true,
        'type'      => 'plain',
        'add_args'  => false,
    );

    printf('<nav class="navigation" role="navigation">%s</nav>',
        paginate_links($paginate_args)
    );
}

add_shortcode('opal_events', 'event_shortcode');