<?php


if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Class OSF_Custom_Post_Type_Footer
 */
class OSF_Custom_Post_Type_Event extends OSF_Custom_Post_Type_Abstract {
    public $post_type = 'osf_event';
    public $taxonomy = 'osf_event_category';
    static $instance;

    public static function getInstance() {
        if (!isset(self::$instance) && !(self::$instance instanceof OSF_Custom_Post_Type_Event)) {
            self::$instance = new OSF_Custom_Post_Type_Event();
        }

        return self::$instance;
    }


    /**
     *
     */
    public function create_post_type() {

        $labels = array(
            'name'               => __('Events', 'worldlife-core'),
            'singular_name'      => __('Events', 'worldlife-core'),
            'add_new'            => __('Add Event', 'worldlife-core'),
            'add_new_item'       => __('Add New Event', 'worldlife-core'),
            'edit_item'          => __('Edit Event', 'worldlife-core'),
            'new_item'           => __('New Event', 'worldlife-core'),
            'all_items'          => __('Events', 'worldlife-core'),
            'view_item'          => __('View Event', 'worldlife-core'),
            'search_items'       => __('Search Event', 'worldlife-core'),
            'not_found'          => __('No Event found', 'worldlife-core'),
            'not_found_in_trash' => __('No Event found in Trash', 'worldlife-core'),
            'menu_name'          => __('Events', 'worldlife-core'),
        );

        $labels = apply_filters('osf_postype_event_labels', $labels);
        $slug_field = osf_get_option('event_settings', 'slug_event', 'event');
        $slug = isset($slug_field) ? $slug_field : "event";
        register_post_type($this->post_type,
            array(
                'labels'        => $labels,
                'supports'      => array('title', 'editor', 'excerpt', 'thumbnail'),
                'public'        => true,
                'has_archive'   => true,
                'rewrite'       => array('slug' => $slug),
                'menu_position' => 5,
                'categories'    => array(),
            )
        );
    }


    /**
     * @return void
     */
    public function create_taxonomy() {
        $labels = array(
            'name'              => __('Categories', "worldlife-core"),
            'singular_name'     => __('Category', "worldlife-core"),
            'search_items'      => __('Search Category', "worldlife-core"),
            'all_items'         => __('All Categories', "worldlife-core"),
            'parent_item'       => __('Parent Category', "worldlife-core"),
            'parent_item_colon' => __('Parent Category:', "worldlife-core"),
            'edit_item'         => __('Edit Category', "worldlife-core"),
            'update_item'       => __('Update Category', "worldlife-core"),
            'add_new_item'      => __('Add New Category', "worldlife-core"),
            'new_item_name'     => __('New Category Name', "worldlife-core"),
            'menu_name'         => __('Categories', "worldlife-core"),
        );
        $slug_cat_field = osf_get_option('event_settings', 'slug_category_event', 'category-event');
        $slug_cat = isset($slug_cat_field) ? $slug_cat_field : "category-event";
        $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'show_in_nav_menus' => false,
            'rewrite'           => array('slug' => $slug_cat)
        );
        // Now register the taxonomy
        register_taxonomy($this->taxonomy, array($this->post_type), $args);
    }

    /**
     *
     */


    public static function getEventQuery($args = array()) {
        $default = array(
            'post_type' => 'osf_event',
        );

        $args = array_merge($default, $args);

        return new WP_Query($args);
    }

    public static function getEventId($post_id = 0) {
        $post_ids = array();
        $array = array(
            'post__not_in' => array($post_id),
        );
        $sevices = self::getEventQuery($array);
        while ($sevices->have_posts()) {
            $sevices->the_post();
            $post_ids[] = get_the_ID();
        }
        wp_reset_postdata();

        return $post_ids;
    }

    /**
     * @param $term_id is term_id in taxonomy
     * @param $post    is name post type
     * @param taxonomy  is name taxonomy
     */
    public static function get_event_by_term_id($term_id, $per_page = -1) {
        wp_reset_query();
        $args = array();
        if ($term_id == 0 || empty($term_id)) {
            $args = array(
                'posts_per_page' => $per_page,
                'post_type'      => "osf_event",
            );
        } else {
            $args = array(
                'posts_per_page' => $per_page,
                'post_type'      => "osf_event",
                'tax_query'      => array(
                    array(
                        'taxonomy' => "osf_event_category",
                        'field'    => 'term_id',
                        'terms'    => $term_id,
                        'operator' => 'IN'
                    )
                )
            );
        }

        return new WP_Query($args);
    }

    /**
     * @param $term_id is term_id in taxonomy
     * @param $post    is name post type
     * @param taxonomy  is name taxonomy
     */
    public static function get_event($per_page = -1) {
        wp_reset_query();
        $args = array(
            'posts_per_page' => $per_page,
            'post_type'      => "osf_event",
        );

        return new WP_Query($args);
    }

    /**
     *
     * @param $post is name post type
     * @param taxonomy  is name taxonomy
     */
    public static function get_the_term_filter_name($post, $taxonomy_name) {
        $terms = wp_get_post_terms($post->ID, $taxonomy_name, array("fields" => "names"));

        return $terms;
    }

    /**
     * Get All Categories
     *
     * @param $args
     */
    public static function getCategoryevents($per_page = 0) {
        $args = array(
            'hide_empty' => false,
            'orderby'    => 'name',
            'order'      => 'ASC',
            'number'     => $per_page,
        );
        $terms = get_terms('osf_event_category', $args);

        return $terms;
    }

    /**
     * @param $term_id is term_id in taxonomy
     * @param $post_id is id post type
     */
    public static function check_active_category_by_post_id($term_id, $post_id) {
        $termid = array();
        $terms = wp_get_post_terms($post_id, 'osf_event_category');
        foreach ($terms as $term) {
            $termid[] = $term->term_id;
        }
        if (in_array($term_id, $termid)) {
            return true;
        }

        return false;
    }

    public function widgets_init() {
        register_sidebar(array(
            'name'          => esc_html__('Event Sidebar', 'worldlife-core'),
            'id'            => 'sidebar-event',
            'description'   => esc_html__('Add widgets here to appear in your Event.', 'worldlife-core'),
            'before_widget' => '<section id="%1$s" class="widget %2$s">',
            'after_widget'  => '</section>',
            'before_title'  => '<h2 class="widget-title">',
            'after_title'   => '</h2>',
        ));
    }

    public function set_sidebar($name) {
        if (is_singular('osf_event') && is_active_sidebar('sidebar-event')) {
            $name = 'sidebar-event';
        }
        return $name;
    }

    public function body_class($classes) {
        if (is_post_type_archive($this->post_type) || is_tax($this->taxonomy)) {
            if (in_array('opal-content-layout-2cr', $classes)) {
                $key = array_search('opal-content-layout-2cr', $classes);
                $classes[$key] = 'opal-content-layout-1c';
            }
        }
        if (is_singular($this->post_type) && is_active_sidebar('sidebar-event')) {
            $classes[] = 'opal-content-layout-2cr';
        }

        return $classes;
    }

    public function create_meta_box() {
        $cmb2 = new_cmb2_box(array(
            'id'            => 'osf_event',
            'title'         => __('Event', 'worldlife-core'),
            'object_types'  => array('osf_event'), // Post type
            'context'       => 'normal',
            'priority'      => 'high',
            'show_names'    => true, // Show field names on the left
            'vertical_tabs' => true,
            'tabs'          => array(
                array(
                    'id'     => 'osf_event_tab1',
                    'title'  => __('Date Time', 'worldlife-core'),
                    'fields' => array(
                        'osf_event_date',
                        'osf_event_date_end',
                    ),
                ),
                array(
                    'id'     => 'osf_event_tab2',
                    'title'  => __('Organizer', 'worldlife-core'),
                    'fields' => array(
                        'osf_event_organizer_phone',
                        'osf_event_organizer_mail',
                        'osf_event_organizer_web',
                    ),
                ),
                array(
                    'id'     => 'osf_event_tab2',
                    'title'  => __('Venue', 'worldlife-core'),
                    'fields' => array(
                        'osf_event_venue_add',
                        'osf_event_venue_phone',
                        'osf_event_venue_web',
                    ),
                ),
            )
        ));

        $cmb2->add_field(array(
            'name' => __('Starting Time', 'worldlife-core'),
            'id'   => 'osf_event_date',
            'type' => 'text_datetime_timestamp',
        ));
        $cmb2->add_field(array(
            'name' => __('End Time', 'worldlife-core'),
            'id'   => 'osf_event_date_end',
            'type' => 'text_datetime_timestamp',
        ));

        //Organizer

        $cmb2->add_field(array(
            'name' => __('Phone', 'worldlife-core'),
            'id'   => 'osf_event_organizer_phone',
            'type' => 'text',
        ));
        $cmb2->add_field(array(
            'name' => __('Email', 'worldlife-core'),
            'id'   => 'osf_event_organizer_mail',
            'type' => 'text_email',
        ));
        $cmb2->add_field(array(
            'name' => __('Website', 'worldlife-core'),
            'id'   => 'osf_event_organizer_web',
            'type' => 'text_url',
        ));

        //Venue

        $cmb2->add_field(array(
            'name' => __('Add', 'worldlife-core'),
            'id'   => 'osf_event_venue_add',
            'type' => 'textarea_small',
        ));
        $cmb2->add_field(array(
            'name' => __('Phone', 'worldlife-core'),
            'id'   => 'osf_event_venue_phone',
            'type' => 'text',
        ));
        $cmb2->add_field(array(
            'name' => __('Website', 'worldlife-core'),
            'id'   => 'osf_event_venue_web',
            'type' => 'text_url',
        ));
    }

}// end class
OSF_Custom_Post_Type_Event::getInstance();